/*********************************************************************
  This code is based on the ssd1306_128x64_i2c example.

*********************************************************************/

// DISPLAY LIBRARIES
#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>   
#include <Adafruit_SSD1306.h>

// DIGITAL TEMP/HUMID SENSOR PIN and TYPE
#include <DHT.h>
#define DHTPIN 2
#define DHTTYPE DHT11
DHT dht(DHTPIN, DHTTYPE);

// LIGHT SENSOR
#define LIGHTSENSOR_PIN 0 // Analog pin

// RELAY CONTROL FOR PUMP AND LIGHT
#define RELAY1_PIN 3 // Digital pin for Light
#define RELAY2_PIN 4 // Digital pin for Pump 

//SENSORS FLAGS
bool DHT_sensor_flag = true;
bool light_sensor_flag = true;
bool ph_sensor_flag = true;
bool water_sensor_flag = true;
bool LCD_flag = true;
bool bluetooth_flag = true;

//AVERAGE ARRAYS DECLARATION
#define NUM_OF_SAMPLES 5
uint16_t tempArray[NUM_OF_SAMPLES];
uint16_t humidityArray[NUM_OF_SAMPLES];
uint16_t lightArray[5];
uint16_t arrayClock=0;

// BLUETOOTH LIBRARY AND VARIABLES
#include <CurieBle.h>
BLEPeripheral blePeripheral; // create peripheral instance
BLEService lflService("F86D"); // create service
// create switch characteristic and allow remote device to read and write
BLEUnsignedCharCharacteristic lightChar("19B10001-F86D", BLERead); 


// RELAY TIMER LIBRARY AND VARIABLES
#include <CurieTime.h>
int ch1TimerTrigger;
int ch2TimerTrigger;
int ch1TimerState = 1;
int ch2TimerState = 1;

#define OLED_RESET 4
Adafruit_SSD1306 display(OLED_RESET);

#define NUMFLAKES 10
#define XPOS 0
#define YPOS 1
#define DELTAY 2


// Display is 128x64
//   16 lines of yellow
//   black gap about 2 lines tall
//   48 lines of blue

#define LOGO16_GLCD_HEIGHT 16
#define LOGO16_GLCD_WIDTH  16
static const unsigned char PROGMEM logo16_glcd_bmp[] =
{ B00000000, B11000000,
  B00000001, B11000000,
  B00000001, B11000000,
  B00000011, B11100000,
  B11110011, B11100000,
  B11111110, B11111000,
  B01111110, B11111111,
  B00110011, B10011111,
  B00011111, B11111100,
  B00001101, B01110000,
  B00011011, B10100000,
  B00111111, B11100000,
  B00111111, B11110000,
  B01111100, B11110000,
  B01110000, B01110000,
  B00000000, B00110000
};

#define LETTUCE_LOGO_WIDTH  128
#define LETTUCE_LOGO_HEIGHT  64
static const unsigned char PROGMEM lettuce_logo_bmp[] =
{

  // Lettuce 1
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 224, 7, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 252, 127, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 7, 192, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 1, 240, 56, 0, 120, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 56, 0, 240, 24, 0, 120, 0, 0, 120, 120, 0, 0, 0, 0, 0, 0, 56, 0, 120, 24, 0, 120, 0, 0, 120, 120, 0, 0, 0, 0, 0, 0, 254, 0, 60, 126, 0, 120, 1, 248, 254, 254, 121, 225, 248, 31, 128, 7, 255, 192, 31, 255, 192, 120, 3, 252, 254, 254, 121, 227, 252, 63, 192, 15, 255, 240, 31, 255, 224, 120, 3, 156, 254, 254, 121, 227, 158, 57, 192, 15, 199, 252, 127, 199, 240, 120, 7, 158, 120, 120, 121, 231, 152, 121, 224, 12, 0, 62, 252, 0, 112, 120, 7, 254, 120, 120, 121, 231, 128, 127, 224, 28, 0, 31, 240, 0, 112, 120, 7, 254, 120, 120, 121, 231, 128, 127, 224, 28, 0, 7, 192, 0, 112, 120, 7, 128, 120, 120, 121, 231, 152, 120, 0, 28, 0, 3, 192, 0, 48, 127, 195, 158, 120, 120, 127, 231, 158, 57, 224, 28, 0, 1, 224, 0, 48, 127, 195, 252, 126, 126, 127, 227, 252, 63, 192, 28, 0, 0, 240, 0, 48, 127, 193, 248, 62, 62, 61, 225, 248, 31, 128, 28, 0, 0, 120, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 0, 0, 56, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 3, 0, 60, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 3, 0, 28, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 7, 0, 14, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 3, 128, 14, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 3, 128, 14, 0, 112, 127, 192, 0, 0, 1, 224, 30, 62, 0, 0, 14, 3, 128, 6, 0, 224, 127, 192, 0, 0, 1, 224, 30, 126, 0, 0, 7, 3, 128, 7, 0, 224, 127, 192, 0, 0, 1, 224, 0, 120, 0, 0, 7, 1, 128, 7, 1, 224, 120, 0, 240, 123, 129, 224, 30, 254, 63, 0, 7, 129, 192, 7, 1, 192, 120, 3, 252, 127, 129, 224, 30, 254, 127, 128, 3, 129, 192, 7, 3, 192, 127, 131, 156, 127, 1, 224, 30, 254, 115, 128, 3, 192, 224, 7, 7, 128, 127, 135, 158, 124, 1, 224, 30, 120, 243, 192, 1, 224, 240, 7, 7, 0, 127, 135, 158, 120, 1, 224, 30, 120, 255, 192, 0, 240, 120, 7, 15, 0, 120, 7, 158, 120, 1, 224, 30, 120, 255, 192, 0, 240, 60, 7, 30, 0, 120, 7, 158, 120, 1, 224, 30, 120, 240, 0, 0, 124, 31, 7, 124, 0, 120, 3, 156, 120, 1, 255, 30, 120, 115, 192, 0, 62, 15, 199, 248, 0, 120, 3, 252, 120, 1, 255, 30, 120, 127, 128, 0, 15, 135, 255, 240, 0, 120, 0, 240, 120, 1, 255, 30, 120, 63, 0, 0, 7, 243, 255, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 255, 255, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 254, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

  // Bentley
  //0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 254, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 255, 255, 192, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 255, 255, 240, 31, 255, 255, 255, 255, 255, 255, 252, 127, 255, 255, 255, 255, 128, 127, 0, 1, 254, 1, 255, 255, 255, 255, 254, 112, 0, 0, 127, 128, 0, 14, 0, 0, 96, 0, 1, 252, 0, 0, 14, 62, 0, 0, 1, 255, 254, 6, 0, 0, 96, 255, 255, 128, 0, 0, 124, 31, 255, 255, 255, 206, 3, 134, 0, 0, 97, 192, 243, 255, 255, 255, 240, 15, 255, 255, 192, 199, 0, 204, 127, 252, 51, 0, 231, 3, 255, 255, 240, 14, 0, 0, 31, 255, 0, 89, 255, 255, 26, 1, 255, 248, 0, 0, 112, 7, 255, 255, 254, 115, 128, 247, 255, 255, 206, 3, 142, 127, 255, 255, 224, 1, 255, 252, 3, 249, 192, 255, 255, 255, 247, 7, 159, 128, 127, 255, 128, 0, 224, 0, 255, 187, 241, 255, 192, 15, 255, 143, 217, 254, 0, 7, 0, 0, 112, 255, 240, 60, 251, 127, 3, 135, 254, 254, 60, 31, 254, 14, 0, 0, 63, 254, 3, 255, 191, 255, 135, 195, 255, 253, 255, 192, 127, 252, 0, 0, 15, 0, 127, 15, 79, 255, 135, 195, 255, 246, 241, 252, 0, 240, 0, 0, 15, 143, 248, 123, 211, 255, 135, 195, 255, 219, 252, 31, 227, 224, 0, 0, 3, 255, 129, 227, 245, 255, 135, 195, 255, 175, 135, 129, 255, 192, 0, 0, 0, 112, 15, 135, 127, 255, 131, 135, 255, 254, 225, 240, 30, 0, 0, 0, 0, 127, 252, 60, 255, 255, 128, 15, 255, 255, 56, 63, 252, 0, 0, 0, 0, 31, 224, 243, 159, 255, 129, 7, 255, 251, 143, 7, 248, 0, 0, 0, 0, 1, 255, 135, 55, 255, 131, 195, 255, 204, 227, 255, 128, 0, 0, 0, 0, 0, 255, 28, 103, 255, 135, 225, 255, 102, 122, 255, 0, 0, 0, 0, 0, 0, 23, 251, 205, 255, 135, 225, 255, 51, 191, 224, 0, 0, 0, 0, 0, 0, 1, 223, 253, 255, 135, 225, 255, 191, 243, 128, 0, 0, 0, 0, 0, 0, 0, 4, 255, 255, 135, 193, 255, 254, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 127, 3, 131, 252, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 127, 192, 7, 252, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 63, 252, 127, 240, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 15, 255, 255, 224, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 7, 255, 255, 192, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 1, 255, 255, 1, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 129, 255, 255, 3, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 195, 122, 189, 135, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 242, 90, 180, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 214, 150, 254, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 150, 210, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 182, 219, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 182, 219, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 254, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

};

#if (SSD1306_LCDHEIGHT != 64)
#error("Height incorrect, please fix Adafruit_SSD1306.h!");
#endif

void setup()   {

  // set the current time to 00:00:00, January 1st, 2016
  setTime(0, 0, 30, 1, 1, 2016);

  Serial.begin(9600);


  // Bluetooth Initialization
  if (bluetooth_flag == true) {
    // set the local name peripheral advertises
    blePeripheral.setLocalName("Lettuce For Life");
    // set the UUID for the service this peripheral advertises
    blePeripheral.setAdvertisedServiceUuid(lflService.uuid());
    // add service and characteristic
    blePeripheral.addAttribute(lflService);
    blePeripheral.addAttribute(lightChar);    
    // assign event handlers for connected, disconnected to peripheral
    blePeripheral.setEventHandler(BLEConnected, blePeripheralConnectHandler);
    blePeripheral.setEventHandler(BLEDisconnected, blePeripheralDisconnectHandler);
    // advertise the service
    blePeripheral.begin();
    Serial.println(("Bluetooth device active, waiting for connections..."));
  }
   
  // Initialize digital humidity and temperature access
  dht.begin();

  // Initialize Relay Pins.
  pinMode(RELAY1_PIN, OUTPUT); // Currently connected for Light
  pinMode(RELAY2_PIN, OUTPUT); // Currently connected for Water Pump

  //Start the device with both relays ON
  digitalWrite(RELAY1_PIN, 1);
  digitalWrite(RELAY2_PIN, 1);

  // Check if any reads failed and exit early (to try again).
  if (isnan(dht.readHumidity()) || isnan(dht.readTemperature(true))) {
    Serial.print("Failed to read from DHT sensor!");
    DHT_sensor_flag = false;
  } 

  if isnan(analogRead(LIGHTSENSOR_PIN)) {
    light_sensor_flag = false;
  } 
     
  // by default, we'll generate the high voltage from the 3.3v line internally! (neat!)
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // initialize with the I2C addr 0x3D (for the 128x64)
  // init done

  // Clear the buffer.
  display.clearDisplay();

  // Display our growing lettuce animation
  do_logo_animation(lettuce_logo_bmp, LETTUCE_LOGO_WIDTH, LETTUCE_LOGO_HEIGHT);

  // Display our lettuce logo for 10 seconds
  //display.drawBitmap(XPOS, YPOS, bitmap, w, h, WHITE);
  //display.drawBitmap(0, 0,  lettuce_logo_bmp, 128, 64, 1);
  //display.display();
  //delay(5000);

  // Clear the buffer.
  //display.clearDisplay();
}

typedef struct sys_readings_s {
  float temperature;
  float humidity;
  uint16_t water_level;
  int pH;
  uint16_t light_level;
} sys_readings_t;

//********************************************************************
//************************ START MAIN LOOP ***************************
//********************************************************************

void loop() {

  //sys_readings_t current_readings;
  //gather_readings(&current_readings);
  bool inFahrenheit_f = true;
  float cur_humidity = dht.readHumidity();
  float cur_temperature = dht.readTemperature(inFahrenheit_f);
  float cur_luminance = analogRead(LIGHTSENSOR_PIN);

   //Print Current Time to serial output
  Serial.print("Time: ");
  print2digits(hour());
  Serial.print(":");
  print2digits(minute());
  Serial.print(":");
  print2digits(second());
  Serial.print(" | ");

  // Show logo
  display.clearDisplay();
  display.drawBitmap(0, 0,  lettuce_logo_bmp, 128, 64, 1);
  display.display();
  
  // display status to LCD
  display.setTextSize(1);
  display.setCursor(0, 0);
  //display.setTextColor(WHITE);
  Serial.print("Reporting ");
  display.setTextColor(WHITE);
  //display.println("STATUS: OK");
  Serial.print("STATUS: OK | ");
   display.display();

//========== DHT SENSOR - START ==========
  if (DHT_sensor_flag == true) {
    //Display to LCD
    display.print("T: ");
    display.print(cur_temperature, 1);
    display.print("F H: ");
    display.print(cur_humidity, 1);
    display.print("%");
    display.display();
    
    //Display to Serial Output
    Serial.print("Humidity: ");
    Serial.print(cur_humidity);
    Serial.print(" | Temperature ");
    if (inFahrenheit_f)
      Serial.print("(F)");
    else
      Serial.print("(C)");
    Serial.print(": ");
    Serial.print(cur_temperature);
    Serial.print(" | ");
  } else {
    display.print("No DHT Sensor|");
    //flash_warning_banner();
  }
//========== DHT SENSOR - END  ==========

//========== LIGHT SENSOR - START ==========
  if (light_sensor_flag == true) {
  //Display Light Sensor information(photocel)
    Serial.print("Light Density: ");
    Serial.print(cur_luminance, DEC);
    Serial.print(" | ");
    display.print("L:");
    display.println(cur_luminance);
  } else {
    Serial.print("No Light Sensor | ");
    display.print("L:FAIL");
  }
  
  if (ph_sensor_flag == true) {
    //ph code here 
  } else {
    display.print("No pH "); 
  }

  if (water_sensor_flag == true) {
    display.print("Conn | ");
    //water level sensor code here
  } else {
    display.print("& WL Sensor");
  }

  TriggerRelay(16, 8, 1); // Light Timer Relay Trigger
  TriggerRelay(1, 5, 2);  // Pump Timer Relay Trigger
  display.println();  
    
      /*  if (cur_luminance <= 550) {
          // Low light, turn on the lamp
          digitalWrite(RELAY1_PIN, 1);
        } else {
          digitalWrite(RELAY1_PIN, 0);
        }
      */
 
  //display.fillRect(0, 0, display.width(), uint8_t(display.height()/5), 1);
  //display.setTextColor(BLACK);
  //display.println("STATUS: REQUIRE ATTENTION ***");
 // Serial.print("STATUS: NOT OK, System requires attention");
  
  //update OLED LCD display
  display.display();
  
  if (bluetooth_flag == true) { 
    // set value for the LIGHT characteristic
    //lightChar.setValue(cur_luminance);
    blePeripheral.poll();
  }
  Serial.println("\n*******************************************************************************************************");
  //display_readings(&current_readings);

  //reset array to the 0 position
  arrayClock++;
  if (arrayClock % NUM_OF_SAMPLES == 0){
    arrayClock=0;
  }
  
  delay(5000);
}

//********************************************************************
//************************** END MAIN LOOP ***************************
//********************************************************************

void flash_warning_banner() {
  Serial.println("Sending warning to alert the user");
  uint8_t cnt;

  for (cnt = 0; cnt < 10; cnt++) {
    display.fillRect(0, 0, display.width(), uint8_t(display.height() / 5), cnt % 2);
    display.setTextColor(!(cnt % 2));
    display.setCursor(0, 0);
    display.println("*** ATTENTION ***");
    display.display();
    delay(750);
  }
}
/*
  bool gather_readings(struct sys_readings_s * retvals) {
  // TODO: Implement data collection from various instruments here
  read_failed_f = false;
  // DEBUG: Fill in with random data
  retvals->temperature = 25.0+(random(10)-5);
  retvals->humidity = 33.0+(random(30)-15);
  retvals->water_level = random(1024);
  retvals->pH = random(7);
  retvals->light_level = random(1024);
  return !read_failed_f;
  }

  void display_readings(sys_readings_t * current_readings) {
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0,0);

  display.println("STATUS: OK");
  //  display.write(i);
  //    display.println();
  display.display();
  delay(1);
  }
*/


void do_logo_animation(const uint8_t *bitmap, uint8_t w, uint8_t h) {
  int8_t ypos;

  Serial.println("Animating logo sequence");
  display.fillRect(0, 0, display.width(), display.height(), WHITE);

  ypos = display.height() - 16 /* num lines of yellow */;
  while (ypos > -1) {
    Serial.print("y: ");
    Serial.print(ypos, DEC);
    Serial.print(";");

    // draw logo
    display.drawBitmap(0, ypos, bitmap, w, h, BLACK);
    display.display();
    delay(200);

    // then erase it + move it
    display.drawBitmap(0, ypos, bitmap, w, h, WHITE);
    // move it
    ypos -= 2;
  }
  Serial.println("\nLogo animation complete");
}



/* Original code from setup()
  // draw a single pixel
  display.drawPixel(10, 10, WHITE);
  // Show the display buffer on the hardware.
  // NOTE: You _must_ call display after making any drawing commands
  // to make them visible on the display hardware!
  display.display();
  delay(2000);
  display.clearDisplay();

  // draw many lines
  testdrawline();
  display.display();
  delay(2000);
  display.clearDisplay();

  // draw rectangles
  testdrawrect();
  display.display();
  delay(2000);
  display.clearDisplay();

  // draw multiple rectangles
  testfillrect();
  display.display();
  delay(2000);
  display.clearDisplay();

  // draw mulitple circles
  testdrawcircle();
  display.display();
  delay(2000);
  display.clearDisplay();

  // draw a white circle, 10 pixel radius
  display.fillCircle(display.width()/2, display.height()/2, 10, WHITE);
  display.display();
  delay(2000);
  display.clearDisplay();

  testdrawroundrect();
  delay(2000);
  display.clearDisplay();

  testfillroundrect();
  delay(2000);
  display.clearDisplay();

  testdrawtriangle();
  delay(2000);
  display.clearDisplay();

  testfilltriangle();
  delay(2000);
  display.clearDisplay();

  // draw the first ~12 characters in the font
  testdrawchar();
  display.display();
  delay(2000);
  display.clearDisplay();

  // draw scrolling text
  testscrolltext();
  delay(2000);
  display.clearDisplay();

  // text display tests
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.println("Lettuce for Life!");
  display.setTextColor(BLACK, WHITE); // 'inverted' text
  display.println(3.141592);
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.print("0x"); display.println(0xDEADBEEF, HEX);
  display.display();
  delay(2000);
  display.clearDisplay();

  // miniature bitmap display
  display.drawBitmap(30, 16,  logo16_glcd_bmp, 16, 16, 1);
  display.display();
  delay(1);

  // invert the display
  display.invertDisplay(true);
  delay(1000);
  display.invertDisplay(false);
  delay(1000);
  display.clearDisplay();

  // draw a bitmap icon and 'animate' movement
  testdrawbitmap(logo16_glcd_bmp, LOGO16_GLCD_HEIGHT, LOGO16_GLCD_WIDTH);
  }
*/


void testdrawchar(void) {
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);

  for (uint8_t i = 0; i < 168; i++) {
    if (i == '\n') continue;
    display.write(i);
    if ((i > 0) && (i % 21 == 0))
      display.println();
  }
  display.display();
  delay(1);
}

void testdrawcircle(void) {
  for (int16_t i = 0; i < display.height(); i += 2) {
    display.drawCircle(display.width() / 2, display.height() / 2, i, WHITE);
    display.display();
    delay(1);
  }
}

void testfillrect(void) {
  uint8_t color = 1;
  for (int16_t i = 0; i < display.height() / 2; i += 3) {
    // alternate colors
    display.fillRect(i, i, display.width() - i * 2, display.height() - i * 2, color % 2);
    display.display();
    delay(1);
    color++;
  }
}

void testdrawtriangle(void) {
  for (int16_t i = 0; i < min(display.width(), display.height()) / 2; i += 5) {
    display.drawTriangle(display.width() / 2, display.height() / 2 - i,
                         display.width() / 2 - i, display.height() / 2 + i,
                         display.width() / 2 + i, display.height() / 2 + i, WHITE);
    display.display();
    delay(1);
  }
}

void testfilltriangle(void) {
  uint8_t color = WHITE;
  for (int16_t i = min(display.width(), display.height()) / 2; i > 0; i -= 5) {
    display.fillTriangle(display.width() / 2, display.height() / 2 - i,
                         display.width() / 2 - i, display.height() / 2 + i,
                         display.width() / 2 + i, display.height() / 2 + i, WHITE);
    if (color == WHITE) color = BLACK;
    else color = WHITE;
    display.display();
    delay(1);
  }
}

void testdrawroundrect(void) {
  for (int16_t i = 0; i < display.height() / 2 - 2; i += 2) {
    display.drawRoundRect(i, i, display.width() - 2 * i, display.height() - 2 * i, display.height() / 4, WHITE);
    display.display();
    delay(1);
  }
}

void testfillroundrect(void) {
  uint8_t color = WHITE;
  for (int16_t i = 0; i < display.height() / 2 - 2; i += 2) {
    display.fillRoundRect(i, i, display.width() - 2 * i, display.height() - 2 * i, display.height() / 4, color);
    if (color == WHITE) color = BLACK;
    else color = WHITE;
    display.display();
    delay(1);
  }
}

void testdrawrect(void) {
  for (int16_t i = 0; i < display.height() / 2; i += 2) {
    display.drawRect(i, i, display.width() - 2 * i, display.height() - 2 * i, WHITE);
    display.display();
    delay(1);
  }
}

void testdrawline() {
  for (int16_t i = 0; i < display.width(); i += 4) {
    display.drawLine(0, 0, i, display.height() - 1, WHITE);
    display.display();
    delay(1);
  }
  for (int16_t i = 0; i < display.height(); i += 4) {
    display.drawLine(0, 0, display.width() - 1, i, WHITE);
    display.display();
    delay(1);
  }
  delay(250);

  display.clearDisplay();
  for (int16_t i = 0; i < display.width(); i += 4) {
    display.drawLine(0, display.height() - 1, i, 0, WHITE);
    display.display();
    delay(1);
  }
  for (int16_t i = display.height() - 1; i >= 0; i -= 4) {
    display.drawLine(0, display.height() - 1, display.width() - 1, i, WHITE);
    display.display();
    delay(1);
  }
  delay(250);

  display.clearDisplay();
  for (int16_t i = display.width() - 1; i >= 0; i -= 4) {
    display.drawLine(display.width() - 1, display.height() - 1, i, 0, WHITE);
    display.display();
    delay(1);
  }
  for (int16_t i = display.height() - 1; i >= 0; i -= 4) {
    display.drawLine(display.width() - 1, display.height() - 1, 0, i, WHITE);
    display.display();
    delay(1);
  }
  delay(250);

  display.clearDisplay();
  for (int16_t i = 0; i < display.height(); i += 4) {
    display.drawLine(display.width() - 1, 0, 0, i, WHITE);
    display.display();
    delay(1);
  }
  for (int16_t i = 0; i < display.width(); i += 4) {
    display.drawLine(display.width() - 1, 0, i, display.height() - 1, WHITE);
    display.display();
    delay(1);
  }
  delay(250);
}

void testscrolltext(void) {
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(10, 0);
  display.clearDisplay();
  display.println("scroll");
  display.display();
  delay(1);

  display.startscrollright(0x00, 0x0F);
  delay(2000);
  display.stopscroll();
  delay(1000);
  display.startscrollleft(0x00, 0x0F);
  delay(2000);
  display.stopscroll();
  delay(1000);
  display.startscrolldiagright(0x00, 0x07);
  delay(2000);
  display.startscrolldiagleft(0x00, 0x07);
  delay(2000);
  display.stopscroll();
}



void TriggerRelay(int onTime, int offTime, int channel) {

  int timerCurrent;
  int stateCurrent;
  int pinCurrent;
  
  if (channel == 1) {

    //Print on Serial Output
    Serial.print("\n[Relay Pump] ");

    //Get time when relay was last trigger time depending on channel
    timerCurrent = hour() - ch1TimerTrigger;
    stateCurrent = ch1TimerState;
    pinCurrent =  RELAY1_PIN;

    //Handles 60 minutes reset scenario
    if (timerCurrent < 0) {
      timerCurrent = timerCurrent + 60;
    }
  } else if (channel == 2) {
    Serial.print("\n[RelayLight] ");
    timerCurrent = minute() - ch2TimerTrigger;
    stateCurrent = ch2TimerState;
    pinCurrent = RELAY2_PIN;
    if (timerCurrent < 0) {
      timerCurrent = timerCurrent + 24;
    }
  } else {
    Serial.print("\n[RelayLight] FAIL - Invalid channel number. Valid entries are 1 or 2");
    return;
  }
 
  
  //breaks out of funticion if not even 1 increment happened yet
  if (timerCurrent == 0) {
    Serial.print("SKIP - Time value has not changed since last triggered. Current State: ");
    Serial.print(stateCurrent);
    return;
  }

  //Print to serial monitor
  Serial.print("Time since last triggered = ");
  Serial.print(timerCurrent);

  //if channel is currently OFF, attempt to run ON
  if (stateCurrent == 0) {
    Serial.print(" | Current State = Low");
    if (timerCurrent % (offTime) == 0) {
      Serial.print(" | Triggering Relay!");
      if (channel == 1) {
        digitalWrite(RELAY1_PIN, 1);
        ch1TimerTrigger = hour();
        ch1TimerState = 1;
      } else {
        digitalWrite(RELAY2_PIN, 1);
        ch2TimerTrigger = minute();
        ch2TimerState = 1;
      }
    }
  }
  //if channel is currently OFF, attempt to run ON
  else if (stateCurrent == 1) {
    Serial.print(" | Current State = High");
    if (timerCurrent % (onTime) == 0) {
      Serial.print(" | Triggering Relay!");
      digitalWrite(pinCurrent, 0);
      if (channel == 1) {        
        digitalWrite(RELAY1_PIN, 0);
        ch1TimerTrigger = hour();
        ch1TimerState = 0;
      } else {
        digitalWrite(RELAY2_PIN, 0);
        ch2TimerTrigger = minute();
        ch2TimerState = 0;
      }
    }
  }
}

void print2digits(int number) {
  if (number >= 0 && number < 10) {
    Serial.print('0');
  }
  Serial.print(number);
}


//********* START BLUETOOTH FUNCTIONS**************
void blePeripheralConnectHandler(BLECentral& central) {
  // central connected event handler
  Serial.print("Connected event, central: ");
  Serial.println(central.address());
}

void blePeripheralDisconnectHandler(BLECentral& central) {
  // central disconnected event handler
  Serial.print("Disconnected event, central: ");
  Serial.println(central.address());
}
//********* END BLUETOOTH FUNCTIONS**************

// Transform 0 and 1 values to ON and OFF words. Return is always 3 char long
const char* On_or_off(int pin_value) {
  if (pin_value == 0) {
    return "OFF";
  }   
  else if (pin_value == 1) {
    return "ON ";
  } 
  else {
    return "BAD";
  }
}


